
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Listado de Válvulas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2 class="text-center mb-4">Listado de Válvulas</h2>

    <!-- Formulario de filtro -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('valvulas') ?>">
        
        <div class="col-md-3">
            <input type="text" name="id_valvula" class="form-control" placeholder="Buscar por id_valvula" value="<?= esc($search['id_valvula'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="tipo" class="form-control" placeholder="Buscar por tipo" value="<?= esc($search['tipo'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="funcion" class="form-control" placeholder="Buscar por funcion" value="<?= esc($search['funcion'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="responsable" class="form-control" placeholder="Buscar por responsable" value="<?= esc($search['responsable'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="ubicacion" class="form-control" placeholder="Buscar por ubicacion" value="<?= esc($search['ubicacion'] ?? '') ?>">
        </div>
        <div class="col-md-3 d-grid">
            <button type="submit" class="btn btn-primary">Filtrar</button>
        </div>
        <div class="col-md-3">
            <a href="<?= base_url('valvulas') ?>" class="btn btn-secondary">Limpiar filtros</a>
        </div>
    </form>

    <div class="text-end mb-3">
        <a href="<?= base_url('valvulas/create') ?>" class="btn btn-success">Crear Registro</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
        <tr>
            <th>Acciones</th>
            <th>id_valvula</th>
            <th>este</th>
            <th>norte</th>
            <th>cota</th>
            <th>diametro</th>
            <th>tipo</th>
            <th>funcion</th>
            <th>edad</th>
            <th>estado</th>
            <th>tapa</th>
            <th>responsable</th>
            <th>ubicacion</th>
            <th>departamen</th>
            <th>provincia</th>
            <th>municipio</th>
            <th>distrito</th>
            <th>otb</th>
            <th>descripci</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($items as $item): ?>
            <tr>
                <td>
                    <a href="<?= base_url('valvulas/view/' . $item['id']) ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="<?= base_url('valvulas/edit/' . $item['id']) ?>" class="btn btn-warning btn-sm">Editar</a>
                    <a href="<?= base_url('valvulas/delete/' . $item['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro de eliminar este registro?');">Eliminar</a>
                </td>
                <td><?= esc($item['id_valvula']) ?></td>
                <td><?= esc($item['este']) ?></td>
                <td><?= esc($item['norte']) ?></td>
                <td><?= esc($item['cota']) ?></td>
                <td><?= esc($item['diametro']) ?></td>
                <td><?= esc($item['tipo']) ?></td>
                <td><?= esc($item['funcion']) ?></td>
                <td><?= esc($item['edad']) ?></td>
                <td><?= esc($item['estado']) ?></td>
                <td><?= esc($item['tapa']) ?></td>
                <td><?= esc($item['responsable']) ?></td>
                <td><?= esc($item['ubicacion']) ?></td>
                <td><?= esc($item['departamen']) ?></td>
                <td><?= esc($item['provincia']) ?></td>
                <td><?= esc($item['municipio']) ?></td>
                <td><?= esc($item['distrito']) ?></td>
                <td><?= esc($item['otb']) ?></td>
                <td><?= esc($item['descripci']) ?></td>
            </tr>
        <?php endforeach ?>
        </tbody>
    </table>

    <!-- Paginación -->
    <div class="d-flex justify-content-center">
        <?= $pager->links() ?>
    </div>
</div>
</body>
</html>

<?= $this->endSection(); ?>


