<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<div class="container mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Detalle de la Transacción
    </h2>

    <div class="card">
        <div class="card-body">
            <dl class="row">
                <dt class="col-sm-3 fw-bold">ID</dt>
                <dd class="col-sm-9"><?= esc($item['id']) ?></dd>

                <dt class="col-sm-3 fw-bold">Tipo</dt>
                <dd class="col-sm-9"><?= esc($item['tipo']) ?></dd>

                <dt class="col-sm-3 fw-bold">Clase</dt>
                <dd class="col-sm-9"><?= esc($item['clase']) ?></dd>

                <dt class="col-sm-3 fw-bold">Esquema</dt>
                <dd class="col-sm-9"><?= esc($item['esquema']) ?></dd>

                <dt class="col-sm-3 fw-bold">Descripción</dt>
                <dd class="col-sm-9"><?= esc($item['descripcion']) ?></dd>

                <dt class="col-sm-3 fw-bold">Fecha Registro</dt>
                <dd class="col-sm-9"><?= esc($item['fecha_i']) ?></dd>

                <dt class="col-sm-3 fw-bold">Usuario Registro</dt>
                <dd class="col-sm-9"><?= esc($item['usuario_i']) ?></dd>

                <dt class="col-sm-3 fw-bold">Fecha Actualización</dt>
                <dd class="col-sm-9"><?= esc($item['fecha_u']) ?></dd>

                <dt class="col-sm-3 fw-bold">Usuario Actualización</dt>
                <dd class="col-sm-9"><?= esc($item['usuario_u']) ?></dd>

                <dt class="col-sm-3 fw-bold">Estado</dt>
                <dd class="col-sm-9"><?= esc($item['estado']) ?></dd>
            </dl>
        </div>
    </div>
    
<?php if (session()->getFlashdata('status')): ?>
    <div class="alert alert-success"><?= session()->getFlashdata('status') ?></div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
<?php endif; ?>

    <div class="text-end mt-3">
        <a href="<?= base_url('transacciones') ?>" class="btn btn-secondary">Volver</a>
        <a href="<?= base_url('transacciones/edit/' . $item['id']) ?>" class="btn btn-primary">Editar</a>
        

        <?php if (esc($item['estado'])==='PROCESADA'): ?>        
        <a href="<?= base_url('transacciones/ejecutar_transaccion/' . $item['id']) ?>" title="Actualizar" class="actualizar" > <i class="btn btn-secondary">Actualizar</i></a>
        <?php endif; ?>
        <?php if (esc($item['estado'])==='ACTIVA'): ?>        
        <a href="<?= base_url('transacciones/ejecutar_transaccion/' . $item['id']) ?>" title="Actualizar" class="actualizar" onclick="return confirm('¿Actualizar transaccion  de red de agua potable?');">        <i class="btn btn-secondary">Actualizar</i></a>
        <?php endif; ?>        
        
        <a href="<?= base_url('transacciones/revertir/' . $item['id']) ?>" title="Revertir" class="revertir" onclick="return confirm('¿Revertir transaccion de red agua potable?');"><i class="btn btn-secondary">Revertir</i></a>

    </div>
</div>

<?= $this->endSection(); ?>
