
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }
    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Red de Agua Potable
    </h2>

    <!-- Formulario de filtros -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('red_agua_potable') ?>">
        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">ID Tubería</label>
            <input type="text" name="id_tuberia" class="form-control form-control-sm" value="<?= esc($search['id_tuberia'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Calle</label>
            <input type="text" name="calle" class="form-control form-control-sm" value="<?= esc($search['calle'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Estado Actual</label>
            <input type="text" name="estado_actual" class="form-control form-control-sm" value="<?= esc($search['estado_actual'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Responsable</label>
            <input type="text" name="responsable" class="form-control form-control-sm" value="<?= esc($search['responsable'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Ubicación</label>
            <input type="text" name="ubicacion" class="form-control form-control-sm" value="<?= esc($search['ubicacion'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">Distrito</label>
            <input type="text" name="distrito" class="form-control form-control-sm" value="<?= esc($search['distrito'] ?? '') ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label fw-bold text-sm">OTB</label>
            <input type="text" name="otb" class="form-control form-control-sm" value="<?= esc($search['otb'] ?? '') ?>">
        </div>

        <!-- Botones -->
        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-buscar">
                <i class="bi bi-search me-1"></i> Buscar
            </button>
            <a href="<?= base_url('red_agua_potable') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-1"></i> Limpiar búsqueda
            </a>
        </div>
    </form>
    
    <?php
    /*
   <!-- Botón Crear -->
    <div class="text-end mb-3">
        <a href="<?= base_url('red_agua_potable/create') ?>" class="btn btn-crear">
            <i class="bi bi-plus-circle"></i> Nueva Tubería
        </a>
    </div>
    */
    ?>
    

<!-- shapefile -->
    
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
<?php endif; ?>


<div class="row">
    <div class="col-md-3 mb-4" style="color: #2d5a86">  
        <h5 class="mb-3"><b>Nueva Tuberia</b>
            
        </h5>
        <form action="<?= site_url('red_agua_potable/importarShape') ?>" method="post" enctype="multipart/form-data">
            
            <input type="file" name="shapefile[]" id="shapefile" multiple required class="form-control">
            <small class="form-text text-muted">
                Puedes seleccionar todos los archivos (.shp, .shx, .dbf, .prj, etc.) a la vez.
            </small>
            
            <div class="text-end mb-3">
                
                <button type="submit" class="btn btn-importar"><i class="bi bi-plus-circle"></i> Importar</button>
            
            
            </div>
        </form>

    </div>
</div>



    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>ID Tubería</th>
                    <th>Calle</th>
                    <th>Estado Actual</th>
                    <th>Responsable</th>
                    <th>Ubicación</th>
                    <th>Distrito</th>
                    <th>OTB</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('red_agua_potable/view/' . $item['gid']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <a href="<?= base_url('red_agua_potable/edit/' . $item['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('red_agua_potable/delete/' . $item['gid']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar este registro?');"><i class="bi bi-trash"></i></a>
                                <a href="<?= base_url('red_agua_potable/ver_red_agua_potable_ol/' . $item['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>
                            </td>
                            <td><?= esc($item['id_tuberia']) ?></td>
                            <td><?= esc($item['calle']) ?></td>
                            <td><?= esc($item['estado_actual']) ?></td>
                            <td><?= esc($item['responsable']) ?></td>
                            <td><?= esc($item['ubicacion']) ?></td>
                            <td><?= esc($item['distrito']) ?></td>
                            <td><?= esc($item['otb']) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection(); ?>

