<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<style>
    .btn-volver {
        background-color: #2d5a86;
        color: white;
    }
    .btn-volver:hover {
        background-color: #16A6BA;
        color: white;
    }
    .campo-valor {
        background-color: #f8f9fa;
        border: 1px solid #ced4da;
        padding: 0.375rem 0.75rem;
        border-radius: 0.2rem;
        font-size: 0.875rem;
        height: calc(1.8125rem + 2px);
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Detalle del Predio
    </h2>

    <fieldset class="border p-2 mb-3">
        <legend class="w-auto px-2 fw-bold text-primary">Información del Predio</legend>
        <div class="row g-2">
            <?php
            $campos = [
                'cod_parcel'   => 'Codigo Parcela',
                'cod_ubicac'   => 'Codigo Ubicacion',
                'cod_fijo'     => 'Codigo Fijo',
                'tipo_predi'   => 'Tipo de Predio',
                'latitud'      => 'Latitud',
                'longitud'     => 'Longitud',
                'calle'        => 'Calle',
                'nombres'      => 'Nombres',
                'apellidos'    => 'Apellidos',
                'serv_agua_'    => 'Servicio de Agua',
                'marc_medid'    => 'Marca Medidor',
                'serie_medi'    => 'Serie Medidor'
            ];

            foreach ($campos as $campo => $label): ?>
                <div class="col-md-4">
                    <label class="form-label fw-bold"><?= $label ?></label>
                    <div class="campo-valor"><?= esc($predio[$campo] ?? '') ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    </fieldset>

    <div class="text-center">
        <a href="<?= base_url('predios') ?>" class="btn btn-volver px-4">Volver</a>
    </div>
</div>

</section>
<?= $this->endSection(); ?>
