<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }

    thead th, tbody td {
        text-align: center;
        vertical-align: middle;
    }

    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }

    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }
</style>

<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Predios
    </h2>

    <!-- Filtros -->
    <form class="row g-3 mb-4" method="get" action="<?= base_url('predios') ?>">
        <?php
        $filtros = [
        'cod_parcel' => 'Codigo Parcela',
        'cod_ubicac' => 'Codigo Ubicacion',
        'cod_fijo'   => 'Codigo Fijo',
        'tipo_predi' => 'Tipo de Predio',
        'latitud'    => 'Latitud',
        'longitud'   => 'Longitud',
        'calle'      => 'Calle',
        'nombres'    => 'Nombres',
        'apellidos'  => 'Apellidos'
    ];
    foreach ($filtros as $campo => $label):
    ?>
    <div class="col-md-3">
        <label class="form-label fw-bold text-sm"><?= $label ?></label>
        <input type="text" name="<?= $campo ?>" class="form-control form-control-sm" value="<?= esc($search[$campo] ?? '') ?>">
    </div>
    <?php endforeach; ?>

        <div class="col-12 d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-buscar">
                <i class="bi bi-search me-1"></i> Buscar
            </button>
            <a href="<?= base_url('predios') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-1"></i> Limpiar búsqueda
            </a>
        </div>
    </form>
    <?php
    /*
    <!-- Botón Crear -->
    <div class="text-end mb-3">
        <a href="<?= base_url('predios/create') ?>" class="btn btn-crear">
            <i class="bi bi-plus-circle"></i> Nuevo Predio
        </a>
    </div>
    */
    ?>
    
    <!-- shapefile -->
    
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
<?php endif; ?>


<div class="row">
    <div class="col-md-3 mb-4" style="color: #2d5a86">  
        <h5 class="mb-3"><b>Nuevo Predio</b>
            
        </h5>
        <form action="<?= site_url('predios/importarShape') ?>" method="post" enctype="multipart/form-data">
            
            <input type="file" name="shapefile[]" id="shapefile" multiple required class="form-control">
            <small class="form-text text-muted">
                Puedes seleccionar todos los archivos (.shp, .shx, .dbf, .prj, etc.) a la vez.
            </small>
            
            <div class="text-end mb-3">
                
                <button type="submit" class="btn btn-importar"><i class="bi bi-plus-circle"></i> Importar</button>
            
            
            </div>
        </form>

    </div>
</div>

    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>Codigo Parcela</th>
                    <th>Codigo Ubicacion</th>
                    <th>Codigo Fijo</th>
                    <th>Tipo de Predio</th>
                    <th>Latitud</th>
                    <th>Longitud</th>
                    <th>Calle</th>
                    <th>Nombres</th>
                    <th>Apellidos</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="10" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('predios/view/' . $item['gid']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <a href="<?= base_url('predios/edit/' . $item['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('predios/delete/' . $item['gid']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar este registro?');"><i class="bi bi-trash"></i></a>
                                <a href="<?= base_url('predios/verpredio_ol/' . $item['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>
                            </td>
                            <td><?= esc($item['cod_parcel']) ?></td>
                            <td><?= esc($item['cod_ubicac']) ?></td>
                            <td><?= esc($item['cod_fijo']) ?></td>
                            <td><?= esc($item['tipo_predi']) ?></td>
                            <td><?= esc($item['latitud']) ?></td>
                            <td><?= esc($item['longitud']) ?></td>
                            <td><?= esc($item['calle']) ?></td>
                            <td><?= esc($item['nombres']) ?></td>
                            <td><?= esc($item['apellidos']) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

</section>
<?= $this->endSection(); ?>
