<?php
function render_input_fields(array $campos, array $datos = [], array $tipos_especiales = [], $col = 'col-md-3') {
    foreach ($campos as $campo) {
        $type = $tipos_especiales[$campo] ?? 'text';
        $label = ucfirst(str_replace('_', ' ', $campo));
        $valor = esc($datos[$campo] ?? '');

        echo '<div class="' . $col . '">';
        echo '<label class="form-label fw-bold text-sm" style="color: #000;">' . $label . '</label>';
        echo '<input type="' . $type . '" class="form-control form-control-sm" name="' . $campo . '" value="' . $valor . '">';
        echo '</div>';
    }
}
?>

<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>


<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Editar Medidor
    </h2>
    <form action="<?= base_url('medidores/update/' . $medidor['gid']) ?>" method="post">

        <!-- Grupo 1: Código -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Código</legend>
            <div class="row">
                <div class="col-md-4">
                    <label for="cod_fijo" class="form-label fw-bold">Código Fijo</label>
                    <input type="text" name="cod_fijo" id="cod_fijo" value="<?= esc($medidor['cod_fijo']) ?>" class="form-control form-control-sm">
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Usuario -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Usuario</legend>
            <div class="row g-2">
                <?php
                $campos = [
                    'cod_usuario' => 'Código Usuario',
                    'nombres' => 'Nombres',
                    'apellidos' => 'Apellidos',
                    'direccion' => 'Dirección',
                    'num_casa' => 'Número Casa',
                    'nit_ci' => 'NIT/CI',
                    'tipo_vivienda' => 'Tipo Vivienda',
                    'categoria' => 'Categoría'
                ];
                foreach ($campos as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?></label>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Acometida -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Acometida</legend>
            <div class="row g-2">
                <?php
                $acometida = [
                    'diam_acometida' => 'Diámetro Acometida',
                    'mat_tub_acometida' => 'Material Tubo',
                    'numero_medidor' => 'Número Medidor',
                    'marca_medidor' => 'Marca Medidor'
                ];
                foreach ($acometida as $campo => $label): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?></label>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 4: Ubicación -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Ubicación</legend>
            <div class="row g-2">
                <?php
                $ubicacion = [
                    'ubicacion', 'este', 'norte', 'cota',
                    'otb', 'distrito', 'municipio', 'provincia', 'departamento'
                ];
                foreach ($ubicacion as $campo): ?>
                    <div class="col-md-3">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= ucfirst($campo) ?></label>
                        <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 5: Abastecimiento y Lectura -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Abastecimiento y Lectura</legend>
            <input type="hidden" name="page" value="<?= esc($page ?? 1) ?>">
            <div class="row g-2">
                <?php
                $lectura = [
                    'zona_abast', 'zona_cod_comercial',
                    'lectura_inicial', 'fecha_lect_inicial',
                    'lectura_final', 'fecha_lect_final'
                ];
                foreach ($lectura as $campo): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= ucfirst(str_replace('_', ' ', $campo)) ?></label>
                        <input type="<?= strpos($campo, 'fecha') !== false ? 'date' : 'text' ?>" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 6: Instalación -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Instalación</legend>
            <div class="row g-2">
                <?php
                $instalacion = [
                    'inst_con_liberacion', 'usu_funcionario', 'fecha_instalacion',
                    'estado_registro', 'tipo_lectura', 'control_datos_crc'
                ];
                foreach ($instalacion as $campo): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= ucfirst(str_replace('_', ' ', $campo)) ?></label>
                        <input type="<?= strpos($campo, 'fecha') !== false ? 'date' : 'text' ?>" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($medidor[$campo]) ?>" class="form-control form-control-sm">
                    </div>
                <?php endforeach; ?>
                <div class="col-md-4">
                    <label for="foto_inicial" class="form-label fw-bold">Foto Inicial</label>
                    <input type="file" name="foto_inicial" id="foto_inicial" class="form-control form-control-sm">
                </div>
            </div>
        </fieldset>

        <!-- Grupo 7: Observaciones -->
        <fieldset class="border p-2 mb-4">
            <legend class="w-auto px-2 fw-bold text-primary">Observaciones</legend>
            <div class="row">
                <div class="col-md-12">
                    <textarea name="observaciones" id="observaciones" rows="3" class="form-control"><?= esc($medidor['observaciones']) ?></textarea>
                </div>
            </div>
        </fieldset>

        <div class="text-center">
            <button type="submit" class="btn btn-primary px-4">Actualizar</button>
            <a href="<?= base_url('medidores') ?>" class="btn btn-secondary px-4">Cancelar</a>
          
    
        </div>
    </form>
</div>

<?= $this->endSection(); ?>

