<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .btn-buscar, .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover, .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    input.form-control:focus, select.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86;">Editar Distrito</h2>

    <form action="<?= base_url('distritos/update/' . $dist['gid']) ?>" method="post">
        <?= csrf_field() ?>

        <!-- Grupo 1: Datos principales -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold text-primary">Datos Generales</legend>
            <div class="row g-2">
                <?php
                $campos = [
                    'codigo'   => 'Codigo Distrito',
                    'id_municipio'   => 'ID Municipio',
                    'sup_ha'     => 'Superficie Hectarea',
                    'distrito'     => 'Distrito'
                ];
                foreach ($campos as $campo => $label): ?>
                    <div class="col-md-4">
                        <label for="<?= $campo ?>" class="form-label fw-bold"><?= $label ?></label>
                        <?php if ($campo === 'distrito'): ?>
                            <select name="distrito" id="distrito" class="form-control form-control-sm">
                                <option value="">Seleccione un distrito...</option>
                                <?php foreach ($distrito as $opcion): ?>
                                    <option value="<?= esc($opcion['distrito']) ?>" <?= $dist['distrito'] === $opcion['distrito'] ? 'selected' : '' ?>>
                                        <?= esc($opcion['distrito']) ?>
                                    </option>
                                <?php endforeach; ?>

                            </select>
                        <?php else: ?>
                            <input type="text" name="<?= $campo ?>" id="<?= $campo ?>" value="<?= esc($dist[$campo] ?? '') ?>" class="form-control form-control-sm">
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>
        

        <!-- Botones -->
        <div class="text-center mt-3">
            <a href="<?= base_url('distritos') ?>" class="btn btn-secondary btn-sm px-4">Cancelar</a>
            <button type="submit" class="btn btn-primary btn-sm px-4">Guardar Cambios</button>
        </div>
    </form>
</div>

<?= $this->endSection(); ?>