
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>

<div class="container mt-3">
    <h2 class="fw-bold text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Detalle de Cámara
    </h2>

    <div class="form">

        <!-- Grupo 1: Código -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Código</legend>
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label fw-bold" style="color: #000;">Código</label>
                    <input type="text" class="form-control form-control-sm" value="<?= esc($camara['codigo']) ?>" readonly>
                </div>
            </div>
        </fieldset>

        <!-- Grupo 2: Ubicación -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Ubicación</legend>
            <div class="row g-2">
                <?php
                $ubicacionCampos = [
                    'otb' => 'OTB',
                    'distrito' => 'Distrito',
                    'nombre_calle' => 'Nombre Calle',
                    'ubicacion' => 'Ubicación',
                    'nom_cuenca' => 'Nombre Cuenca',
                    'este' => 'Este',
                    'norte' => 'Norte'
                ];
                foreach ($ubicacionCampos as $name => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label fw-bold" style="color: #000;"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($camara[$name]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 3: Características -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Características</legend>
            <div class="row g-2">
                <?php
                $caracteristicas = [
                    'altura' => 'Altura',
                    'diametro' => 'Diámetro',
                    'forma' => 'Forma',
                    'cota' => 'Cota',
                    'caida' => 'Caída',
                    'estado' => 'Estado',
                    'numero_cruce' => 'Número Cruce',
                    'material_tapa' => 'Material Tapa',
                    'cod_activos_fijos' => 'Código Activos Fijos',
                    'fecha_instalacion' => 'Fecha Instalación',
                    'fecha_habilitacion' => 'Fecha Habilitación',
                    'valor_instalacion' => 'Valor Instalación'
                ];
                foreach ($caracteristicas as $name => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label fw-bold" style="color: #000;"><?= $label ?></label>
                        <input type="<?= strpos($name, 'fecha') !== false ? 'date' : 'text' ?>" 
                               class="form-control form-control-sm"
                               value="<?= esc($camara[$name]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 4: Proyecto -->
        <fieldset class="border p-2 mb-2">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Proyecto</legend>
            <div class="row g-2">
                <?php
                $otrosCampos = [
                    'tipo_inversion' => 'Tipo Inversión',
                    'nom_proyecto' => 'Nombre Proyecto',
                    'emp_responsable' => 'Empresa Responsable',
                    'supervisor' => 'Supervisor',
                    'encargado_lev' => 'Encargado Levantamiento',
                    'resp_catastro' => 'Responsable Catastro'
                ];
                foreach ($otrosCampos as $name => $label): ?>
                    <div class="col-md-3">
                        <label class="form-label fw-bold" style="color: #000;"><?= $label ?></label>
                        <input type="text" class="form-control form-control-sm" value="<?= esc($camara[$name]) ?>" readonly>
                    </div>
                <?php endforeach; ?>
            </div>
        </fieldset>

        <!-- Grupo 5: Observaciones -->
        <fieldset class="border p-2 mb-3">
            <legend class="w-auto px-2 fw-bold" style="color: #2d5a86;">Observaciones</legend>
            <label class="form-label fw-bold" style="color: #000;">Observaciones</label>
            <textarea rows="3" class="form-control form-control-sm" readonly><?= esc($camara['observaciones']) ?></textarea>
        </fieldset>

        <div class="text-center mt-3">
            <a href="<?= base_url('camaras') ?>" class="btn btn-sm btn-secondary px-4">Volver</a>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>


