
<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>
<section class="content">


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    /* Botones de acción */
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    /* Cabecera de la tabla */
    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    /* Celdas del cuerpo */
    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    /* Botones */
    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }

    /* Inputs al enfocar */
    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
    .acciones a {
        color: #2d5a86;
        margin-right: 10px;
        font-size: 1.1rem;
        transition: color 0.3s ease, background-color 0.3s ease;
        padding: 6px;
        border-radius: 5px;
        text-decoration: none;
    }
    .acciones a:hover {
        background-color: rgba(77, 130, 188, 0.1);
        color: #16A6BA;
    }
    .acciones a.eliminar:hover {
        background-color: rgba(255, 0, 0, 0.1);
        color: darkred;
    }

    thead {
        background-color: #2d5a86;
        color: white;
    }
    thead th {
        text-align: center !important;
        vertical-align: middle !important;
    }

    tbody td {
        text-align: center;
        vertical-align: middle;
    }
    tbody td.acciones {
        text-align: left;
    }

    .btn-buscar,
    .btn-crear {
        background-color: #2d5a86;
        color: white;
    }
    .btn-buscar:hover,
    .btn-crear:hover {
        background-color: #16A6BA;
        color: white;
    }
    .btn-importar {
        background-color: #2d5a86;
        color: white;
    }
    .btn-importar:hover {
        background-color: #16A6BA; /* You can change the hover color if desired */
        color: white;
    }

    input.form-control:focus {
        border: 2px solid #16A6BA;
        box-shadow: 0 0 6px rgba(22, 166, 186, 0.5);
        outline: none;
    }
</style>



<div class="container-fluid mt-4">
    <h2 class="fw-bolder text-center mb-4" style="color: #2d5a86; font-size: 1.9rem;">
        Listado de Cámaras
    </h2>

   <!-- Formulario de filtros -->
<form class="row g-3 mb-4" method="get" action="<?= base_url('camaras') ?>">

    <!-- Campos de búsqueda con etiquetas -->
    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Código</label>
        <input type="text" name="codigo" class="form-control form-control-sm" value="<?= esc($search['codigo'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Nombre de Calle</label>
        <input type="text" name="nombre_calle" class="form-control form-control-sm" value="<?= esc($search['nombre_calle'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Cota</label>
        <input type="text" name="cota" class="form-control form-control-sm" value="<?= esc($search['cota'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Fecha Instalación</label>
        <input type="text" name="fecha_instalacion" class="form-control form-control-sm" value="<?= esc($search['fecha_instalacion'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Diámetro</label>
        <input type="text" name="diametro" class="form-control form-control-sm" value="<?= esc($search['diametro'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Nombre de Cuenca</label>
        <input type="text" name="nom_cuenca" class="form-control form-control-sm" value="<?= esc($search['nom_cuenca'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Fecha Habilitación</label>
        <input type="text" name="fecha_habilitacion" class="form-control form-control-sm" value="<?= esc($search['fecha_habilitacion'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label fw-bold text-sm">Distrito</label>
        <input type="text" name="distrito" class="form-control form-control-sm" value="<?= esc($search['distrito'] ?? '') ?>">
    </div>

    <!-- Botones -->
    <div class="col-12 d-flex justify-content-end gap-2">
        <button type="submit" class="btn btn-buscar">
            <i class="bi bi-search me-1"></i> Buscar cámaras
        </button>
        <a href="<?= base_url('camaras') ?>" class="btn btn-secondary">
            <i class="bi bi-x-circle me-1"></i> Limpiar búsqueda
        </a>
    </div>
</form>


    <!-- Botón Crear -->
    
    <?php
    /*
    <div class="text-end mb-3">
        <a href="<?= base_url('camaras/create') ?>" class="btn btn-crear">
            <i class="bi bi-plus-circle"></i> Nueva Cámara
        </a>
    </div>
    */
    ?>


      <!-- shapefile -->
    
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
<?php endif; ?>


<div class="row">
    <div class="col-md-3 mb-4" style="color: #2d5a86">  
        <h5 class="mb-3"><b>Nueva Camara</b>
            
        </h5>
        <form action="<?= site_url('camaras/importarShape') ?>" method="post" enctype="multipart/form-data">
            
            <input type="file" name="shapefile[]" id="shapefile" multiple required class="form-control">
            <small class="form-text text-muted">
                Puedes seleccionar todos los archivos (.shp, .shx, .dbf, .prj, etc.) a la vez.
            </small>
            
            <div class="text-end mb-3">
                
                <button type="submit" class="btn btn-importar"><i class="bi bi-plus-circle"></i> Importar</button>
            
            
            </div>
        </form>

    </div>
</div>


    <!-- Tabla -->
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped">
            <thead>
                <tr>
                    <th>Acciones</th>
                    <th>Código</th>
                    <th>Calle</th>
                    <th>Cota</th>
                    <th>Fecha Instalación</th>
                    <th>Diámetro</th>
                    <th>Altura</th>
                    <th>Estado</th>
                    <th>Ubicación</th>
                    <th>Forma</th>
                    <th>Material Tapa</th>
                    <th>Cuenca</th>
                    <th>Cod. Activos Fijos</th>
                    <th>Fecha Habilitación</th>
                    <th>Distrito</th>
                    <th>OTB</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                    <tr>
                        <td colspan="20" class="text-center text-muted">No se encontraron resultados.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($items as $cam): ?>
                        <tr>
                            <td class="acciones">
                                <a href="<?= base_url('camaras/view/' . $cam['gid']) ?>" title="Ver"><i class="bi bi-eye"></i></a>
                                <a href="<?= base_url('camaras/edit/' . $cam['gid']) ?>" title="Editar"><i class="bi bi-pencil-square"></i></a>
                                <a href="<?= base_url('camaras/delete/' . $cam['gid']) ?>" title="Eliminar" class="eliminar" onclick="return confirm('¿Eliminar esta cámara?');"><i class="bi bi-trash"></i></a>
                                <a href="<?= base_url('camaras/ver_camaras_ol/' . $cam['gid']) ?>" class="btn btn-info btn-sm">Mapa</a>
                            </td>
                            <td><?= esc($cam['codigo']) ?></td>
                            <td><?= esc($cam['nombre_calle']) ?></td>
                            <td><?= esc($cam['cota']) ?></td>
                            <td><?= esc($cam['fecha_instalacion']) ?></td>
                            <td><?= esc($cam['diametro']) ?></td>
                            <td><?= esc($cam['altura']) ?></td>
                            <td><?= esc($cam['estado']) ?></td>
                            <td><?= esc($cam['ubicacion']) ?></td>
                            <td><?= esc($cam['forma']) ?></td>
                            <td><?= esc($cam['material_tapa']) ?></td>
                            <td><?= esc($cam['nom_cuenca']) ?></td>
                            <td><?= esc($cam['cod_activos_fijos']) ?></td>
                            <td><?= esc($cam['fecha_habilitacion']) ?></td>
                            <td><?= esc($cam['distrito']) ?></td>
                            <td><?= esc($cam['otb']) ?></td>
                        </tr>
                    <?php endforeach ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end mt-3">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection(); ?>






