<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;


class Red_alcantarilladoModel extends Model
{
    protected $table      = 'bdgeo.red_alcantarillado';
    protected $primaryKey = 'gid';
    protected $returnType = 'array';
    protected $allowedFields = [
        'id_tuberia',
        'diametro',
        'pendiente',
        'calle',
        'estado_actual',
        'responsable',
        'longitud',
        'material',
        'tipo_tuberia',
        'ubicacion',
        'profundidad',
        'departamento',
        'provincia',
        'municipio',
        'distrito',
        'otb',
        'observaciones'
    ];

    /**
     * Aplica filtros para búsqueda (sensibles a texto o números)
     *
     * @param array $filtros
     * @return $this
     */
    public function buscar(array $filtros)
    {
        foreach ($filtros as $campo => $valor) {
            if (!empty($valor)) {
                if (in_array($campo, ['id_tuberia', 'longitud'])) {
                    // Campos numéricos o exactos
                    $this->where($campo, $valor);
                } else {
                    // Campos texto: búsqueda insensible a mayúsculas/minúsculas
                    $this->where("LOWER($campo) LIKE", '%' . strtolower($valor) . '%');
                }
            }
        }
        return $this;
    }
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
    
}

