<?php

namespace App\Models;

use CodeIgniter\Model;

use App\Libraries\Auditoria;

class Red_agua_potableModel extends Model
{
    protected $table            = 'bdgeo.red_agua_potable';
    protected $primaryKey       = 'gid';
    protected $returnType       = 'array';
    protected $useTimestamps    = false;

    protected $allowedFields    = [
        'id_tuberia',
        'diametro',
        'longitud',
        'material',
        'funcion_tuberia',
        'tipo_tuberia',
        'profundidad',
        'estado_actual',
        'calle',
        'ubicacion',
        'dist_de_la_red',
        'otb',
        'distrito',
        'municipio',
        'provincia',
        'departamento',
        'responsable',
        'observaciones'
    ];

    /**
     * Aplica filtros personalizados para búsqueda
     */
    public function buscar($filtros)
    {
        foreach ($filtros as $campo => $valor) {
            if (!empty($valor)) {
                // Para campos numéricos: comparación directa
                if (in_array($campo, ['id_tuberia'])) {
                    $this->where($campo, (int) $valor);
                } else {
                    // Para texto: búsqueda insensible a mayúsculas
                    $this->like("LOWER($campo)", strtolower($valor));
                }
            }
        }

        return $this;
    }
    
    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
        
}
