<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class GroupModel extends Model
{
    // Nombre de la tabla en la base de datos
    protected $table         = 'admin.groups';
    // Clave primaria de la tabla
    protected $primaryKey    = 'id';
    // Tipo de retorno de los resultados (array en este caso)
    protected $returnType    = 'array';
    // Indica si se deben usar campos de timestamp (created_at, updated_at, deleted_at)
    protected $useTimestamps = false;

    // Campos de la tabla que están permitidos para ser insertados o actualizados
    protected $allowedFields = [
        'name',
        'description'
    ];

    /**
     * Aplica filtros personalizados para búsqueda en la tabla de grupos.
     *
     * @param array $filtros Un array asociativo con los campos y valores a filtrar.
     * @return $this Retorna la instancia del modelo para encadenar métodos.
     */
    public function buscar($filtros)
    {
        // Itera sobre cada filtro proporcionado
        foreach ($filtros as $campo => $valor) {
            // Verifica si el valor del filtro no está vacío
            if (!empty($valor)) {
                // Si el campo es 'id', realiza una comparación directa (numérica)
                if ($campo === 'id') {
                    $this->where($campo, (int) $valor);
                } else {
                    // Para otros campos (name, description), realiza una búsqueda insensible a mayúsculas y minúsculas
                    // utilizando la función LOWER() de PostgreSQL y el método like() de CodeIgniter.
                    $this->like("LOWER($campo)", strtolower($valor));
                }
            }
        }

        // Retorna la instancia del modelo con los filtros aplicados
        return $this;
    }

    public function insert_auditor($data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->insert($data);
        $db->transCommit();
        return true;
    } 
    
    public function update_auditor($id, $data)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->update($id, $data);
        $db->transCommit();
        return true;
    } 
    
    public function delete_auditor($id)
    {
        $db = \Config\Database::connect();
        $db->transBegin();
        $auditoria = new Auditoria($db);
        $auditoria->actualizar_backend_pid();
        $this->delete($id);
        $db->transCommit();
        return true;
    } 
    
    
}