<?php

namespace App\Models;

use CodeIgniter\Model;

class DistritoModel extends Model
{
    protected $table         = 'bdgeo.distritos';
    protected $primaryKey    = 'gid';
    protected $returnType    = 'array';
    protected $useTimestamps = false;

    protected $allowedFields = [
    'codigo',
    'sup_ha',
    'distrito',
    'id_municipio'
    ];

    /**
     * Aplica filtros personalizados y retorna QueryBuilder para usar paginación manual
     */

public function getFilteredData(?int $limit = null, int $offset = 0, array $filters = [])
{
    $builder = $this->db->table($this->table);

    foreach ($filters as $campo => $valor) {
        if (!empty($valor) && in_array($campo, $this->allowedFields)) {
            if ($campo === 'sup_ha') {
                // Para sup_area (campo numérico), aplicar comparación exacta o rango
                if (is_numeric($valor)) {
                    $builder->where($campo, (float)$valor);
                }
            } else {
                // Para campos texto usar ILIKE con LOWER
                $builder->where("LOWER($campo) ILIKE '%" . strtolower($valor) . "%'");
            }
        }
    }

    $builder->orderBy('gid', 'ASC');

    if ($limit !== null) {
        return $builder->get($limit, $offset);
    }

    return $builder->get();
}


public function getFilteredCount($filters = [])
{
    $builder = $this->db->table($this->table);

    if (!empty($filters['codigo'])) {
        $builder->where("LOWER(codigo) ILIKE '%" . strtolower($filters['codigo']) . "%'");
    }

    if (!empty($filters['sup_ha'])) {
        if (is_numeric($filters['sup_ha'])) {
            $builder->where('sup_ha', (float) $filters['sup_ha']);
        }
    }

    if (!empty($filters['distrito'])) {
        $builder->where("LOWER(distrito) ILIKE '%" . strtolower($filters['distrito']) . "%'");
    }

    if (!empty($filters['id_municipio'])) {
        $builder->where("LOWER(id_municipio) ILIKE '%" . strtolower($filters['id_municipio']) . "%'");
    }

    return $builder->countAllResults();
}

}