<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\Auditoria;

class ConceptosModel extends Model
{
    protected $table            = 'bdgeo.conceptos';
    protected $primaryKey       = 'gid';
    protected $returnType       = 'array';
    protected $useTimestamps    = false;

    protected $allowedFields    = [
        'concepto',
        'desde',
        'hasta',
        'nombre',
        'descripcion',
        'numero',
        'porcentaje',
        'monto',
        'rango1',
        'rango2',
        'rango3',
        'referencia',
        'tipoconcepto',
        'clase',
    ];

    public function buscar($filtros)
    {
        foreach ($filtros as $campo => $valor) {
            if (!empty($valor)) {
                $this->like("LOWER($campo)", strtolower($valor));
            }
        }
        return $this;
    }
}
