<?php

namespace App\Controllers;

use App\Models\MantenimientoModel;
use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

// Asegúrate de que tu AdminController de CI4 extienda BaseController.
// Si no tienes un AdminController personalizado en CI4, puedes extender BaseController directamente.
class Mantenimiento extends BaseController // O 'AdminController' si lo tienes
{
    /**
     * @var MantenimientoModel Instancia del modelo de Mantenimiento.
     */
    protected $MantenimientoModel;

    /**
     * @var array Ayudantes (helpers) a cargar automáticamente para este controlador.
     */
    protected $helpers = ['form', 'url', 'filesystem']; // 'filesystem' para delete_files()

    /**
     * Datos que se pasarán a la vista.
     * @var array
     */
    protected $data = [];

    /**
     * Inicializa el controlador.
     * Este método es el equivalente al constructor en CI3 para la inicialización del controlador.
     *
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     * @param LoggerInterface   $logger
     * @return void
     */
     
        
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        // Cargar el modelo de Mantenimiento
        $this->MantenimientoModel = new MantenimientoModel();

        // Cargar archivos de idioma si es necesario.
        // CI4 maneja la carga de idiomas automáticamente según la configuración regional.
        // Puedes establecer la configuración regional si es necesario: Services::language()->setLocale('es');

        // Título de la página y Breadcrumbs (simplificado, ya que CI4 no tiene librerías directas como CI3)
        // En una aplicación CI4 real, esto se manejaría con un sistema de plantillas o componentes de vista.
        $this->data['pagetitle'] = 'Mantenimiento'; 
        $this->data['breadcrumb'] = '<a href="' . url_to('dashboard') . '" class="text-blue-600 hover:underline">Mantenimiento</a>'; // Placeholder

        // Verificación de módulo para el reset de las variables de sesión utilizadas.
        // Usando el servicio de sesión de CI4.
        $session = session();
        if ($session->get('id_modulo') !== 'MANTENIMIENTO') {
            $session->set('id_modulo', 'MANTENIMIENTO');
        }
    }
    

    public function index() 
    {
        // Comprobación de autenticación y rol de administrador (placeholder para Ion Auth).
        // Debes integrar tu propia lógica de autenticación de CI4 aquí (ej. con Shield).
        // Por ahora, asume que 'isLoggedIn' y 'isAdmin' se establecen en la sesión.
        //if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
        //    return redirect()->to(url_to('Auth::login')); // Ajusta a tu ruta de login de CI4
        //}

        // Añadir "Mantenimiento" al breadcrumb
        $this->data['breadcrumb'] .= ' <span class="mx-2">/</span> Mantenimiento';

        // Obtener datos del proyecto
        // 'first()' es el equivalente a 'row()' en CI4 Models
        $proy_datos = $this->MantenimientoModel->where('id_proyecto', $id_proyec)->first();

        // Si el proyecto no se encuentra, lanzar una excepción 404
        if (!$proy_datos) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Proyecto no encontrado.');
        }

        // Preparar la información del proyecto para la vista
        // Se envuelve en un array para que el 'foreach' en la vista funcione como en CI3 con 'result_array()'
        $this->data['expe_info'] = [$proy_datos];

        /************* CANTIDAD DATOS GRAFICOS ****************/
        $datos_graficos = []; // Inicializar como array vacío
        $datos_graficos[0]['MOPC_FD_LINEA']      = $this->MantenimientoModel->contadorRegistros('franja_dominio_pol', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_FC_LINEA']      = $this->MantenimientoModel->contadorRegistros('franja_construccion', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_EJE']           = $this->MantenimientoModel->contadorRegistros('eje', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_PROGRESIVAS']   = $this->MantenimientoModel->contadorRegistros('progresivas', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_TRAMOS']        = $this->MantenimientoModel->contadorRegistros('ide_tramos', ['id_proyecto' => $id_proyec]);
        $datos_graficos[0]['MOPC_TERRENOS']      = $this->MantenimientoModel->contadorRegistros('terrenos_ci', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_MEJORAS']       = $this->MantenimientoModel->contadorRegistros('mejoras_ci', ['id_proyec' => $id_proyec]);
        /************* FIN CANTIDAD DATOS GRAFICOS ****************/

        $this->data['datos_graficos'] = $datos_graficos;

        // Preparar datos para los campos ocultos en el formulario de la vista
        // En CI4, es más común pasar directamente los valores o acceder a ellos desde el objeto $proy_datos en la vista.
        // Mantengo la estructura de array para compatibilidad con la vista si espera 'value'.
        $this->data['id'] = ['value' => $proy_datos->id_proyecto];
        $this->data['codigo'] = ['value' => $proy_datos->expediente]; // Asumiendo que 'expediente' es el 'codigo'
        $this->data['id_proyecto'] = ['value' => $proy_datos->id_proyecto];

        // Ejecutar script externo
        // 'trim' no es estrictamente necesario para exec, pero se mantiene por consistencia.
        $command = "/dir_sigapas/exp_mopc_expropia_proyec_tabla_a_shp.sh postgres Elefante2025i7 " . trim($id_proyec);
        exec($command);

        // Obtener mensajes flashdata (ej. de operaciones anteriores)
        $this->data['message'] = session()->getFlashdata('message');

        // Cargar la vista. 'view()' es la forma en CI4.
        return view('proyectos/mantenimiento_view', $this->data);
    }


    /**
     * Muestra la vista de mantenimiento de un proyecto específico.
     *
     * @param int|string $id_proyec El ID del proyecto.
     * @return ResponseInterface|string
     */
     
    public function man($id_proyec)
    {
        // Comprobación de autenticación y rol de administrador (placeholder para Ion Auth).
        // Debes integrar tu propia lógica de autenticación de CI4 aquí (ej. con Shield).
        // Por ahora, asume que 'isLoggedIn' y 'isAdmin' se establecen en la sesión.
        //if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
        //    return redirect()->to(url_to('Auth::login')); // Ajusta a tu ruta de login de CI4
        //}

        // Añadir "Mantenimiento" al breadcrumb
        $this->data['breadcrumb'] .= ' <span class="mx-2">/</span> Mantenimiento';

        // Obtener datos del proyecto
        // 'first()' es el equivalente a 'row()' en CI4 Models
        $proy_datos = $this->MantenimientoModel->where('id_proyecto', $id_proyec)->first();

        // Si el proyecto no se encuentra, lanzar una excepción 404
        if (!$proy_datos) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Proyecto no encontrado.');
        }

        // Preparar la información del proyecto para la vista
        // Se envuelve en un array para que el 'foreach' en la vista funcione como en CI3 con 'result_array()'
        $this->data['expe_info'] = [$proy_datos];

        /************* CANTIDAD DATOS GRAFICOS ****************/
        $datos_graficos = []; // Inicializar como array vacío
        $datos_graficos[0]['MOPC_FD_LINEA']      = $this->MantenimientoModel->contadorRegistros('franja_dominio_pol', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_FC_LINEA']      = $this->MantenimientoModel->contadorRegistros('franja_construccion', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_EJE']           = $this->MantenimientoModel->contadorRegistros('eje', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_PROGRESIVAS']   = $this->MantenimientoModel->contadorRegistros('progresivas', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_TRAMOS']        = $this->MantenimientoModel->contadorRegistros('ide_tramos', ['id_proyecto' => $id_proyec]);
        $datos_graficos[0]['MOPC_TERRENOS']      = $this->MantenimientoModel->contadorRegistros('terrenos_ci', ['id_proyec' => $id_proyec]);
        $datos_graficos[0]['MOPC_MEJORAS']       = $this->MantenimientoModel->contadorRegistros('mejoras_ci', ['id_proyec' => $id_proyec]);
        /************* FIN CANTIDAD DATOS GRAFICOS ****************/

        $this->data['datos_graficos'] = $datos_graficos;

        // Preparar datos para los campos ocultos en el formulario de la vista
        // En CI4, es más común pasar directamente los valores o acceder a ellos desde el objeto $proy_datos en la vista.
        // Mantengo la estructura de array para compatibilidad con la vista si espera 'value'.
        $this->data['id'] = ['value' => $proy_datos->id_proyecto];
        $this->data['codigo'] = ['value' => $proy_datos->expediente]; // Asumiendo que 'expediente' es el 'codigo'
        $this->data['id_proyecto'] = ['value' => $proy_datos->id_proyecto];

        // Ejecutar script externo
        // 'trim' no es estrictamente necesario para exec, pero se mantiene por consistencia.
        $command = "/dir_sigapas/exp_mopc_expropia_proyec_tabla_a_shp.sh postgres Elefante2025i7 " . trim($id_proyec);
        exec($command);

        // Obtener mensajes flashdata (ej. de operaciones anteriores)
        $this->data['message'] = session()->getFlashdata('message');

        // Cargar la vista. 'view()' es la forma en CI4.
        return view('proyectos/mantenimiento_view', $this->data);
    }

    /**
     * Elimina las geometrías de un proyecto.
     *
     * @param int|null $id_proyecto El ID del proyecto.
     * @return ResponseInterface
     */
    public function eliminarGeometriasProyecto($id_proyecto = NULL)
    {
        // Comprobación de autenticación (placeholder)
        if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
            return redirect()->to(url_to('Auth::login'));
        }

        // Llamar al método del modelo para eliminar geometrías
        $resultado = $this->MantenimientoModel->eliminarGeometriasProyecto($id_proyecto);

        // Establecer mensaje flashdata
        session()->setFlashdata('message', '¡LOS DATOS ESPACIALES SE ELIMINARON!');

        // Redirigir de vuelta a la página de mantenimiento del proyecto
        return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyecto));
    }

    /**
     * Elimina los datos de Franja de Dominio (FD) de un proyecto.
     *
     * @param int|null $id_proyecto El ID del proyecto.
     * @return ResponseInterface
     */
    public function eliminarFdProyecto($id_proyecto = NULL)
    {
        // Comprobación de autenticación (placeholder)
        if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
            return redirect()->to(url_to('Auth::login'));
        }

        $resultado = $this->MantenimientoModel->eliminarFdProyecto($id_proyecto);

        session()->setFlashdata('message', '¡LOS DATOS ESPACIALES SE ELIMINARON!');
        return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyecto));
    }

    /**
     * Elimina los datos de Franja de Construcción (FC) de un proyecto.
     *
     * @param int|null $id_proyecto El ID del proyecto.
     * @return ResponseInterface
     */
    public function eliminarFcProyecto($id_proyecto = NULL)
    {
        // Comprobación de autenticación (placeholder)
        if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
            return redirect()->to(url_to('Auth::login'));
        }

        $resultado = $this->MantenimientoModel->eliminarFcProyecto($id_proyecto);

        session()->setFlashdata('message', '¡LOS DATOS ESPACIALES SE ELIMINARON!');
        return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyecto));
    }

    /**
     * Elimina los datos de Progresivas de un proyecto.
     *
     * @param int|null $id_proyecto El ID del proyecto.
     * @return ResponseInterface
     */
    public function eliminarProgreProyecto($id_proyecto = NULL)
    {
        // Comprobación de autenticación (placeholder)
        if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
            return redirect()->to(url_to('Auth::login'));
        }

        $resultado = $this->MantenimientoModel->eliminarProgreProyecto($id_proyecto);

        session()->setFlashdata('message', '¡LOS DATOS ESPACIALES SE ELIMINARON!');
        return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyecto));
    }

    /**
     * Descarga los shapes de un proyecto.
     *
     * @param int|null $id_proyec El ID del proyecto.
     * @return ResponseInterface
     */
    public function downloadProyecto($id_proyec = NULL)
    {
        // Comprobación de autenticación (placeholder)
        if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
            return redirect()->to(url_to('Auth::login'));
        }

        // Ejecutar script externo para generar el archivo ZIP
        $command = "/dir_sigapas/exp_mopc_expropia_proyec_tabla_a_shp.sh postgres Elefante2025i7 " . trim($id_proyec);
        exec($command);

        // En CI4, la descarga forzada se maneja típicamente con el objeto Response.
        // Si el script genera un archivo que debe ser descargado, necesitarías verificar su existencia
        // y luego usar Response->download(). Por ahora, solo redirige después de ejecutar el script.
        return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyec));
    }

    /**
     * Maneja la importación de archivos shapefiles.
     *
     * @return ResponseInterface
     */
    public function importarShapes()
    {
        // Comprobación de autenticación (placeholder)
        if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
            return redirect()->to(url_to('Auth::login'));
        }

        $session = session();
        $request = service('request'); // Obtener la instancia de Request

        // Obtener los archivos subidos (CI4 maneja esto de forma diferente a $_FILES)
        $files = $request->getFiles();

        // Verificar si se seleccionó alguna carpeta/archivo
        // 'shapes' es el nombre del campo de entrada de archivos en la vista
        if (empty($files['shapes'])) {
            $session->setFlashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
            return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $request->getPost('id_proyecto')));
        }

        $id_proyecto     = $request->getPost('id_proyecto');
        $numero_contrato = $request->getPost('numero_contrato'); // No usado en esta función, pero se mantiene por el original
        $anyo_contrato   = $request->getPost('anyo_contrato');     // No usado en esta función, pero se mantiene por el original

        $accion = (int)$request->getPost('accion');
        // El original tenía un 'isset' y luego un 'else' que asignaba 0.
        // Si 'accion' no está presente, getPost() devuelve null, y (int)null es 0.
        // Si 'accion' está presente pero es vacía, (int)'' es 0.
        // Así que esta línea es suficiente: $accion = (int)$request->getPost('accion');

        $id_epsg = 32721; // EPSG por defecto

        // Comprobar si existen datos gráficos del proyecto (se asume que el modelo tiene este método)
        // $proyecto_exists = $this->MantenimientoModel->existeGraficoIdProyecto($id_proyecto);
        // El código original de CI3 comentaba la comprobación y procedía, así que se sigue esa lógica.

        // Eliminar y crear el directorio del proyecto para los shapes subidos
        $project_dir = '/dir_sigapas/proyectos/proyecto' . trim($id_proyecto);

        if (is_dir($project_dir)) {
            // Eliminar archivos recursivamente. 'delete_files' es del helper 'filesystem'.
            delete_files($project_dir, true);
            // Eliminar el directorio vacío
            rmdir($project_dir);
        }
        // Crear el directorio recursivamente con permisos 0777
        mkdir($project_dir, 0777, true);
        chmod($project_dir, 0777); // Asegurar permisos para el directorio

        $ruta_dest = $project_dir . '/';

        $uploaded_files_count = 0;
        // Iterar sobre los archivos subidos. 'shapes' es el nombre del campo de entrada.
        foreach ($files['shapes'] as $file) {
            // Verificar si el archivo es válido y no ha sido movido
            if ($file->isValid() && !$file->hasMoved()) {
                $file_extension = strtolower($file->getClientExtension());
                // Mover solo los archivos de shapefile relevantes
                if (in_array($file_extension, ['dbf', 'shp', 'shx', 'prj', 'cpg'])) { // Añadir .prj y .cpg que son comunes en shapefiles
                    $file->move($ruta_dest, $file->getName());
                    $uploaded_files_count++;
                }
            }
        }

        // Si no se subió ningún archivo SHP, SHX o DBF válido
        if ($uploaded_files_count === 0) {
            $session->setFlashdata('message', 'No se encontraron archivos SHP, SHX o DBF válidos para importar.');
            return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyecto));
        }

        // Ejecutar script externo para importar shapes a la base de datos
        $import_command = '/dir_sigapas/imp_mopc_expropia_proyectos_shp_a_tabla.sh ' . trim($id_proyecto) . ' ' . $id_epsg;
        exec($import_command);

        $actu = null; // Inicializar $actu

        // Lógica de actualización basada en la acción
        if ($accion == 1) {
            $id_epsg = 32721; // Se mantiene 32721 para esta acción
            $actu = $this->MantenimientoModel->actualizarShapesProyecto($id_proyecto, $id_epsg);
        } elseif ($accion == 2) {
            $id_epsg = 32720;
            // No hay llamada a 'actualizar_shapes_proyecto' para accion 2 en el original
        } elseif ($accion == 3) {
            $id_epsg = 4326;
            // No hay llamada a 'actualizar_shapes_proyecto' para accion 3 en el original
        }

        if ($accion == 4) {
            // El original tenía un 'show_error', lo reemplazamos por un mensaje flashdata
            $session->setFlashdata('message', 'Acción 4 (Actualizar Progresivas) está temporalmente inactiva.');
            $actu = $this->MantenimientoModel->actualizarShapesProgre($id_proyecto, $id_epsg);
        }

        // Manejo de mensajes de error/éxito
        // Asumiendo que $actu devuelve 2 o 4 en caso de error específico
        if ($actu === 2 || $actu === 4) {
            $mensaje = $this->MantenimientoModel->mensajeError($id_proyecto); // Asumiendo que este método devuelve el mensaje directamente
            $session->setFlashdata('message', $mensaje);
            return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyecto));
        } else {
            $session->setFlashdata('message', '<h3>¡IMPORTADOS!</h3>');
            return redirect()->to(url_to('Mantenimiento::proyecto_mantenimiento', $id_proyecto));
        }
    }

    /**
     * Redirige al visor gráfico externo.
     *
     * @param int|null $id_proyec El ID del proyecto.
     * @return ResponseInterface
     */
    public function verGrafico($id_proyec = NULL)
    {
        // Comprobación de autenticación (placeholder)
        if (! session()->get('isLoggedIn') || ! session()->get('isAdmin')) {
            return redirect()->to(url_to('Auth::login'));
        }

        // Construir la URL del visor externo
        $i_jamap = "http://134.255.178.19/sgeMap/index.html?id_proyec=" . $id_proyec;
        $i_jamap .= "&tipo_consulta=mopc_proyectos_id_proyec";

        // Redirigir a la URL externa
        return redirect()->to($i_jamap);
    }
}