<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/login', 'Auth::login');
$routes->get('/', 'Auth::login');
$routes->get('/auth/login', 'Auth::login');
$routes->post('/auth/login', 'Auth::login');
$routes->get('/logout', 'Auth::logout');
$routes->get('auth/obtenerClaveEncriptada', 'Auth::obtenerClaveEncriptada');
$routes->get('auth/cerrarSesion', 'Auth::cerrarSesion');
$routes->get('/dashboard', 'Dashboard::index');


$routes->get('/users', 'Users::index');

// Rutas para el módulo de Usuarios
$routes->get('users', 'Users::index');
$routes->get('users/create', 'Users::create');
$routes->post('users/store', 'Users::store');
$routes->get('users/edit/(:num)', 'Users::edit/$1');
$routes->post('users/update/(:num)', 'Users::update/$1');
$routes->get('users/delete/(:num)', 'Users::delete/$1');
$routes->get('users/view/(:num)', 'Users::view/$1');


// Rutas para el módulo de Predios
$routes->get('/predios', 'Predios::index');
$routes->get('/predios/create', 'Predios::create');
$routes->post('/predios/store', 'Predios::store');
$routes->get('/predios/edit/(:num)', 'Predios::edit/$1');
$routes->post('/predios/update/(:num)', 'Predios::update/$1');
$routes->get('/predios/delete/(:num)', 'Predios::delete/$1');
$routes->get('/predios/view/(:num)', 'Predios::view/$1');
$routes->get('/predios/verpredio_ol/(:num)', 'Predios::verpredio_ol/$1');
$routes->post('predios/importarShape', 'Predios::importarShape');


// Rutas para el módulo de OTBS
$routes->get('/otbs', 'Otbs::index');
$routes->get('/otbs/create', 'Otbs::create');
$routes->post('/otbs/store', 'Otbs::store');
$routes->get('/otbs/edit/(:num)', 'Otbs::edit/$1');
$routes->post('/otbs/update/(:num)', 'Otbs::update/$1');
$routes->get('/otbs/view/(:num)', 'Otbs::view/$1');
$routes->get('otbs/delete/(:num)', 'Otbs::delete/$1');
$routes->get('/otbs/ver_otbs_ol/(:num)', 'Otbs::ver_otbs_ol/$1');
$routes->post('otbs/importarShape', 'Otbs::importarShape');

// Rutas para el módulo de Manzanas
$routes->get('/manzanas', 'Manzanas::index');
$routes->get('/manzanas/create', 'Manzanas::create');
$routes->post('/manzanas/store', 'Manzanas::store');
$routes->get('/manzanas/edit/(:num)', 'Manzanas::edit/$1');
$routes->post('/manzanas/update/(:num)', 'Manzanas::update/$1');
$routes->get('/manzanas/view/(:num)', 'Manzanas::view/$1');
$routes->get('manzanas/delete/(:num)', 'Manzanas::delete/$1');
$routes->get('/manzanas/ver_manzanas_ol/(:num)', 'Manzanas::ver_manzanas_ol/$1');
$routes->post('manzanas/importarShape', 'Manzanas::importarShape');

// Rutas para el módulo de Distritos
$routes->get('/distritos', 'Distritos::index');
$routes->get('/distritos/create', 'Distritos::create');
$routes->post('/distritos/store', 'Distritos::store');
$routes->get('/distritos/edit/(:num)', 'Distritos::edit/$1');
$routes->post('/distritos/update/(:num)', 'Distritos::update/$1');
$routes->get('/distritos/view/(:num)', 'Distritos::view/$1');
$routes->get('distritos/delete/(:num)', 'Distritos::delete/$1');
$routes->get('/distritos/ver_distritos_ol/(:num)', 'Distritos::ver_distritos_ol/$1');
$routes->post('distritos/importarShape', 'Distritos::importarShape');

// Rutas para el módulo de Red agua potable
$routes->get('red_agua_potable', 'Red_agua_potable::index');
$routes->get('red_agua_potable/create', 'Red_agua_potable::create');
$routes->post('red_agua_potable/store', 'Red_agua_potable::store');
$routes->get('red_agua_potable/edit/(:num)', 'Red_agua_potable::edit/$1');
$routes->post('red_agua_potable/update/(:num)', 'Red_agua_potable::update/$1');
$routes->get('red_agua_potable/view/(:num)', 'Red_agua_potable::view/$1');
$routes->get('red_agua_potable/delete/(:num)', 'Red_agua_potable::delete/$1');
$routes->get('red_agua_potable/ver_red_agua_potable_ol/(:num)', 'Red_agua_potable::ver_red_agua_potable_ol/$1');
$routes->post('red_agua_potable/importarShape', 'Red_agua_potable::importarShape');

// Rutas para el módulo de alcantarillado
$routes->get('red_alcantarillado', 'Red_alcantarillado::index');
$routes->get('red_alcantarillado/create', 'Red_alcantarillado::create');
$routes->post('red_alcantarillado/store', 'Red_alcantarillado::store');
$routes->get('red_alcantarillado/edit/(:num)', 'Red_alcantarillado::edit/$1');
$routes->post('red_alcantarillado/update/(:num)', 'Red_alcantarillado::update/$1');
$routes->get('red_alcantarillado/view/(:num)', 'Red_alcantarillado::view/$1');
$routes->get('red_alcantarillado/delete/(:num)', 'Red_alcantarillado::delete/$1');
$routes->get('red_alcantarillado/ver_red_alcantarillado_ol/(:num)', 'Red_alcantarillado::ver_red_alcantarillado_ol/$1');
$routes->post('red_alcantarillado/importarShape', 'Red_alcantarillado::importarShape');

// Rutas para el módulo de Valvulas
$routes->get('valvulas', 'Valvulas::index');
$routes->get('valvulas/create', 'Valvulas::create');
$routes->post('valvulas/store', 'Valvulas::store');
$routes->get('valvulas/edit/(:num)', 'Valvulas::edit/$1');
$routes->post('valvulas/update/(:num)', 'Valvulas::update/$1');
$routes->get('valvulas/view/(:num)', 'Valvulas::view/$1');
$routes->get('valvulas/delete/(:num)', 'Valvulas::delete/$1');
$routes->get('valvulas/ver_valvulas_ol/(:num)', 'Valvulas::ver_valvulas_ol/$1');
$routes->post('valvulas/importarShape', 'Valvulas::importarShape');

// Rutas para el módulo de Camaras
$routes->get('camaras', 'Camaras::index');
$routes->get('camaras/create', 'Camaras::create');
$routes->post('camaras/store', 'Camaras::store');
$routes->get('camaras/edit/(:num)', 'Camaras::edit/$1');
$routes->post('camaras/update/(:num)', 'Camaras::update/$1');
$routes->get('camaras/view/(:num)', 'Camaras::view/$1');
$routes->get('camaras/delete/(:num)', 'Camaras::delete/$1');
$routes->get('camaras/ver_camaras_ol/(:num)', 'Camaras::ver_camaras_ol/$1');
$routes->post('camaras/importarShape', 'Camaras::importarShape');


// Rutas para el módulo de Medidores
$routes->get('medidores', 'Medidores::index');
$routes->get('medidores/create', 'Medidores::create');
$routes->post('medidores/store', 'Medidores::store');
$routes->get('medidores/edit/(:num)', 'Medidores::edit/$1');
$routes->post('medidores/update/(:num)', 'Medidores::update/$1');
$routes->get('medidores/delete/(:num)', 'Medidores::delete/$1');
$routes->get('medidores/view/(:num)', 'Medidores::view/$1');
$routes->get('medidores/ver_medidores_ol/(:num)', 'Medidores::ver_medidores_ol/$1');
$routes->post('medidores/importarShape', 'Medidores::importarShape');

// Rutas para el módulo de Conceptos
$routes->get('conceptos', 'Conceptos::index');
$routes->get('conceptos/create', 'Conceptos::create');
$routes->post('conceptos/store', 'Conceptos::store');
$routes->get('conceptos/edit/(:num)', 'Conceptos::edit/$1');
$routes->post('conceptos/update/(:num)', 'Conceptos::update/$1');
$routes->get('conceptos/delete/(:num)', 'Conceptos::delete/$1');

// Rutas para el módulo de Transacciones
$routes->get('transacciones', 'Transacciones::index');
$routes->get('transacciones/create', 'Transacciones::create');
$routes->post('transacciones/store', 'Transacciones::store');
$routes->get('transacciones/edit/(:num)', 'Transacciones::edit/$1');
$routes->post('transacciones/update/(:num)', 'Transacciones::update/$1');
$routes->get('transaccioness/delete/(:num)', 'Transacciones::delete/$1');
$routes->get('transacciones/view/(:num)', 'Transacciones::view/$1');
$routes->get('transacciones/ejecutar_transaccion/(:num)', 'Transacciones::ejecutar_transaccion/$1');
$routes->get('transacciones/revertir/(:num)', 'Transacciones::revertir/$1');
$routes->get('transacciones/preparar/(:num)', 'Transacciones::preparar/$1');

$routes->group('groups', function($routes){
    $routes->get('/', 'Groups::index');
    $routes->get('view/(:num)', 'Groups::view/$1');
    $routes->get('create', 'Groups::create');
    $routes->post('store', 'Groups::store');
    $routes->get('edit/(:num)', 'Groups::edit/$1');
    $routes->post('update/(:num)', 'Groups::update/$1');
    $routes->get('delete/(:num)', 'Groups::delete/$1');
});

$routes->get('mantenimiento/man/(:num)', 'Mantenimiento::man/$1'); // Si tu vista está en el inicio
$routes->get('mantenimiento', 'Mantenimiento::index'); // Si tu vista está en el inicio
$routes->get('mantenimiento/index', 'Mantenimiento::index'); // Si tu vista está en el inicio
$routes->get('mantenimiento/uploadFiles', 'Mantenimiento::uploadFiles'); // Si tu vista está en el inicio
$routes->post('mantenimiento/uploadFiles', 'Mantenimiento::uploadFiles');
$routes->post('mantenimiento/importData', 'Mantenimiento::importData'); // Para llamadas AJAX
$routes->get('mantenimiento/downloadFolder/(:any)', 'Mantenimiento::downloadFolder/$1');
$routes->get('mantenimiento/viewFolderContents/(:any)', 'Mantenimiento::viewFolderContents/$1');

